// get inputs
if (global.gameState == PLAY) mouseClick = mouse_check_button_pressed(mb_left); 
else mouseClick = 0; 

// create bullet
if (mouseClick && ammo != 0) {
	
	// establish temporary vars for creating bullet
	var _gunWidth, _xx, _yy, _bulletLayer, _bullet; 
	
	// find coordinates to create bullet
	_gunWidth = sprite_get_width(gunSprite); 
	_xx = lengthdir_x(_gunWidth, gunDirection) * 1.25; 
	_yy = lengthdir_y(_gunWidth, gunDirection); 
	_bulletLayer = layer_get_name("Bullets");
	
	// create bullet object
	_bullet = instance_create_layer(x + _xx, y + _yy, _bulletLayer, bulletObject); 
	_bullet.direction = gunDirection; // set bullet direction
	_bullet.speed = bulletSpeed; // set bullet speed
	_bullet.image_angle = gunDirection; // set image angle
	ammo--; // subtract ammo
	
	audio_play_sound(sndShoot, 2, false); 
	
}

// count down shot buffer
if (instance_exists(oBullet)) shotBuffer--; 

if (hit) {

	hp--; 
	if (hp <= 10) image_alpha = hp/10; 
	
}

// update gun direction
gunDirection = point_direction(x, y, mouse_x, mouse_y); 

// determine which direction the cowboy is facing
var _limitRight = gunDirection <= 360 && gunDirection > 270; 
var _limitLeft = gunDirection >= 180 && gunDirection <= 270; 

if (_limitRight) {
	gunDirection = 0; // limit angle of gun
}

if (_limitLeft) {
	gunDirection = 180; // limit angle of gun
}

depth = -y; 